<?php 
include ('includes/header.php');

//table name
$table_name = "leaguesx";
$page = "leagues.php";

// Fetch the leagues data from the JSON endpoint
$json_url = "https://www.thesportsdb.com/api/v1/json/60130162/all_leagues.php";
$json_data = file_get_contents($json_url);
$leagues = json_decode($json_data, true);
//table call
$res = $db->select($table_name, '*', '', '');

//update call
@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);

if(isset($_POST['submitU'])){
	unset($_POST['submitU']);
	$updateData = $_POST;
	$db->update($table_name, $updateData, 'id = :id',[':id' => $_GET['update']]);
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//submit new
if (isset($_POST['submit'])){
	unset($_POST['submit']);
	$db->insert($table_name, $_POST);
	$db->close();
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//delete row
if(isset($_GET['delete'])){
	$db->delete($table_name, 'id = :id',[':id' => $_GET['delete']]);
	echo "<script>window.location.href='".$page."?status=2'</script>";
}

?>
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content" style="background-color: black;">
            <div class="modal-header">
                <h2 style="color: white;">Confirm</h2>
            </div>
            <div class="modal-body" style="color: white;">
                Do you really want to delete?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                <a style="color: white;" class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>
<?php
if (isset($_GET['create'])){

//create form
?>

<div class="col-md-12 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-bullhorn"></i> Create League ID</h2>
                </center>
            </div>

            <div class="card-body">
                <div class="col-12">
                    <h3>Choose League</h3>
                </div>
                <form method="post">
                    <div class="form-group ctinput">
                        <label class="form-label" for="league">League</label>
                        <select name="league" id="league" class="form-control" onchange="updateLeagueId(this)">
                            <?php foreach ($leagues['leagues'] as $league): ?>
                            <option value="<?= htmlspecialchars($league['strLeague']) ?>"
                                data-idleague="<?= htmlspecialchars($league['idLeague']) ?>"
                                <?= (isset($updateData['leagueId']) && $updateData['leagueId'] === $league['strLeague']) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($league['strLeague']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="leagueId">League ID</label>
                        <input class="form-control" id="leagueId" name="leagueId" placeholder="League ID" type="text"
                            readonly />
                    </div>
                    <div class="form-group ctinput">
                        <center>
                            <button class="btn btn-info " name="submit" type="submit">
                                <i class="icon icon-check"></i> Submit
                            </button>
                        </center>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php 
 }else{
//main table/form
	 ?>

<div class="col-md-12 mx-auto ctmain-table">
    <div class="card-body">
        <div class="card ctcard">
            <div class="card-header card-header-warning">
                <center>
                    <h2><i class="icon icon-commenting"></i> Leagues</h2>
                </center>
            </div>
            <div class="card-body">
                <div class="col-12">
                    <center>
                        <a id="button" href="./<?=$page ?>?create" class="btn btn-info">Create League ID</a>
                    </center>
                </div>
                <br>
                <div class="table-responsive">
                    <table class="table table-striped table-sm">
                        <thead style="color:white!important">
                            <tr>
                                <th>League name</th>
                                <th>League ID</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                        <?php foreach ($res as $row) {
							?>
                        <tbody>
                            <tr>
                                <td><?=$row['league'] ?></a></td>
                                <td><?=$row['leagueId'] ?></td>
                                <td>
                                    &nbsp&nbsp&nbsp
                                    <a class="btn btn-danger btn-ok" href="#"
                                        data-href="<?=$page ?>?delete=<?=$row['id'] ?>" data-toggle="modal"
                                        data-target="#confirm-delete"><i class="fa fa-trash-o"></i></a>
                                </td>
                            </tr>
                        </tbody>
                        <?php
							}?>
                    </table>
                </div>
            </div>
        </div>
    </div>


</div>
<?php }?>
<script>
function updateLeagueId(selectElement) {
    var leagueId = selectElement.options[selectElement.selectedIndex].dataset.idleague;
    document.getElementById('leagueId').value = leagueId;
}

// Call the function on page load to set the initial value
window.onload = function() {
    var selectElement = document.getElementById('leagueId');
    updateLeagueId(selectElement);
};
</script>
<?php include ('includes/footer.php');?>

</body>

</html>